package jamezo97.clonecraft.entity.clone;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.GuiHandler;
import jamezo97.clonecraft.Ray;
import jamezo97.clonecraft.Reflect;
import jamezo97.clonecraft.Synchronize.DataSynchronizer;
import jamezo97.clonecraft.Synchronize.SyncData;
import jamezo97.clonecraft.Synchronize.SyncValue;
import jamezo97.clonecraft.Synchronize.Synchronizable;
import jamezo97.clonecraft.entity.EntityExplodeCollapseFX;
import jamezo97.clonecraft.entity.EntityModifiable;
import jamezo97.clonecraft.entity.clone.AI.EntityAIAttackEnemies;
import jamezo97.clonecraft.entity.clone.AI.EntityAIAttackMe;
import jamezo97.clonecraft.entity.clone.AI.EntityAIBreakBlock;
import jamezo97.clonecraft.entity.clone.AI.EntityAICloneEat;
import jamezo97.clonecraft.entity.clone.AI.EntityAICloneLookIdle;
import jamezo97.clonecraft.entity.clone.AI.EntityAICloneReturnToGuard;
import jamezo97.clonecraft.entity.clone.AI.EntityAICloneWalkToItems;
import jamezo97.clonecraft.entity.clone.AI.EntityAIFollowCloneOwner;
import jamezo97.clonecraft.network.Handler15Synchronize;
import jamezo97.clonecraft.network.Handler6UpdateAll;
import jamezo97.clonecraft.network.NetworkHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureObject;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet42RemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.CloneCraftWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

import org.apache.commons.lang3.ArrayUtils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class EntityClone extends EntityModifiable implements Synchronizable{

	@SyncValue(uniqueId = 0, callId = 0)
	public String nameUnedited = "Steve";

	@SyncValue(uniqueId = 1, channel = 1, callId = 1)
	public String owner = "";

	@SyncValue(uniqueId = 2, callId = 2)
	public PlayerTeam team = PlayerTeam.Good;

	@SyncValue(uniqueId = 3, callId = 3)
	float scale = .5f;

	@SyncValue(uniqueId = 4, callId = 4)
	float maxScale = 1.0f;

	@SyncValue(uniqueId = 5, channel = 1, callId = 5)
	public int experienceLevel;
	@SyncValue(uniqueId = 6, channel = 1, callId = 5)
	public int experienceTotal;
	@SyncValue(uniqueId = 7, channel = 1, callId = 5)
	public float experience;

	@SyncValue(uniqueId = 8, callId = 6)
	public int selectedItem = 0;

	@SyncValue(uniqueId = 9, channel = 1, callId = 7)
	int foodLevel = 20;

	public static int ID_NAME = 0, ID_OWNER = 1, ID_TEAM = 2, ID_SCALE = 3, ID_MAXSCALE = 4, ID_EXPERIENCE = 5,
			ID_SELECTED_ITEM = 6, ID_FOOD = 7;



	public FoodStatsClone foodStats = new FoodStatsClone();

	public CloneOptions options = new CloneOptions(this);

	public int xpCooldown = 0;

	public DataSynchronizer sync;

	//TODO Fix, if falling, teleport and negate damage :)
	
	public EntityClone(World par1World) {
		super(par1World);
		sync = new DataSynchronizer(this, false);
		inventory = new InventoryClone(this);
		yOffset = 0;
		setSize(.5f/*8*/, 1.62f);
		setName("Steve");
		this.setSpeedInAir(.04f);


		addAITasks();
		setName("Steve");
		
		this.baseSizeX = 0.5f;
		this.baseSizeY = 1.62f;
//		super.setGene(Gene.speedIncrease, 50);
	}


	public boolean isEatingFood(){
		if(/*Is Eating*/isEating() && isUsingItem()){
			ItemStack use = this.getItemInUse();
			if(use.getItem().getItemUseAction(use) == EnumAction.eat){
				return true;
			}
		}
		return false;
	}

	protected void applyEntityAttributes()
    {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setAttribute(20.0D);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setAttribute(0.30000001192092896D);
        this.getAttributeMap().func_111150_b(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setAttribute(1.0D);
    }

	EntityAIBreakBlock aiBreakBlocks;

	public void addAITasks(){
		this.tasks.addTask(0, new EntityAISwimming(this));
		this.tasks.addTask(1, new EntityAICloneEat(this));
		this.tasks.addTask(2, new EntityAIAttackEnemies(this));
		this.tasks.addTask(3, new EntityAIFollowCloneOwner(this));

		this.targetTasks.addTask(1, new EntityAIAttackMe(this, EntityMob.class, 16));

		this.tasks.addTask(3, aiBreakBlocks = new EntityAIBreakBlock(this, 16));
		this.tasks.addTask(4, new EntityAICloneWalkToItems(this));
//		this.tasks.addTask(4, new EntityAICloneWander(this, this.getMoveSpeed()));
		this.tasks.addTask(4, new EntityAICloneLookIdle(this));
		this.tasks.addTask(4, new EntityAICloneReturnToGuard(this));

	}


	@Override
	protected boolean isAIEnabled() {
		return true;
	}

	//TODO Updates

	@Override
	public void onEntityUpdate() {
		super.onEntityUpdate();
		if (this.worldObj.difficultySetting == 0 && this.getHealth() < this.getMaxHealth() && this.ticksExisted % 20 * 12 == 0)
		{
			this.heal(1);
		}
		if(getEntityToAttack() == null && options.guard.value && posX > guardPosX && posX < guardPosX+1 && posZ > guardPosZ && posZ < guardPosZ+1){
			this.setRotation(guardYaw, guardPitch);
		}

	}

	private boolean isItemInUse = false;

	@Override
	public void onUpdate() {
		if(!worldObj.isRemote){
			inventory.preUpdate();
			this.getNavigator().setSpeed(getMoveSpeed());
		}
		super.onUpdate();
		if (this.itemInUse != null)
		{
			ItemStack itemstack = this.inventory.getCurrentItem();
			//			System.out.println(itemstack + "," + itemInUse + "," + worldObj.isRemote);
			if (itemstack == this.itemInUse)
			{
				itemInUse.getItem().onUsingItemTick(itemInUse, getEntityPlayer(), itemInUseCount);
				if (this.itemInUseCount <= 25 && this.itemInUseCount % 4 == 0)
				{
					this.updateItemUse(itemstack, 5);
				}
				//				System.out.println("Decrement: " + itemInUseCount);
				if (--this.itemInUseCount == 0 && !this.worldObj.isRemote)
				{
					this.onItemUseFinish();
				}
			}
			else
			{
				this.clearItemInUse();
			}
		}
		updateExperience();
		if(!worldObj.isRemote){
			foodStats.onUpdate(this);
			pickUpNearbyItems();
			updateMyDataToNewWatchers();
			//			updateChangedData();

			if(!isAttacking() && !isUsingItem() && !isEatingFood()){
				if(aiBreakBlocks == null || !aiBreakBlocks.isMining){
					inventory.currentItem = 0;
				}
			}else{
				Entity e = this.getEntityToAttack();
				if(e != null){
					getLookHelper().setLookPositionWithEntity(e, 30.0F, 30.0F);
				}
			}
		}

		if (!this.isItemInUse && this.isEating() && this.inventory.mainInventory[this.inventory.currentItem] != null)
		{
			ItemStack itemstack = this.inventory.mainInventory[this.inventory.currentItem];
			this.setItemInUse(this.inventory.mainInventory[this.inventory.currentItem], Item.itemsList[itemstack.itemID].getMaxItemUseDuration(itemstack));
			this.isItemInUse = true;
		}
		else if (this.isItemInUse && !this.isEating())
		{
			this.clearItemInUse();
			this.isItemInUse = false;
		}


		if(!worldObj.isRemote){
			sync.synchronize();
		}
	}
	
	public boolean isEating(){
		return this.getFlag(4);
	}

	/*	public void log(String s){
		if(!worldObj.isRemote){
			System.out.println(s);
		}
	}*/



	@Override
	public void onLivingUpdate() {
		super.onLivingUpdate();
		this.updateArmSwingProgress();
		if(!worldObj.isRemote){
			if(options.sprint.value() && !getNavigator().noPath()){
				if(!isSprinting()){
					setSprinting(true);
				}
			}else{
				if(isSprinting()){
					setSprinting(false);
				}
			}
			if(timeSinceLastAttack > 0){
				timeSinceLastAttack --;
			}
			if(!isAttacking() && isItemInUse && inventory.getCurrentItem() != null && inventory.getCurrentItem().getItemUseAction() == EnumAction.bow){
				setIsChargingBow(false);
			}
		}
		inventory.decrementAnimations();
	}

	/**
	 * Plays sounds and makes particles for item in use state
	 */
	protected void updateItemUse(ItemStack par1ItemStack, int par2)
	{
		if (par1ItemStack.getItemUseAction() == EnumAction.drink)
		{
			this.playSound("random.drink", 0.5F, this.worldObj.rand.nextFloat() * 0.1F + 0.9F);
		}

		if (par1ItemStack.getItemUseAction() == EnumAction.eat)
		{
			for (int j = 0; j < par2; ++j)
			{
				Vec3 vec3 = this.worldObj.getWorldVec3Pool().getVecFromPool(((double)this.rand.nextFloat() - 0.5D) * 0.1D, Math.random() * 0.1D + 0.1D, 0.0D);
				vec3.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0F);
				vec3.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0F);
				Vec3 vec31 = this.worldObj.getWorldVec3Pool().getVecFromPool(((double)this.rand.nextFloat() - 0.5D) * 0.3D, (double)(-this.rand.nextFloat()) * 0.6D - 0.3D, 0.6D);
				vec31.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0F);
				vec31.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0F);
				vec31 = vec31.addVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ);
				this.worldObj.spawnParticle("iconcrack_" + par1ItemStack.getItem().itemID, vec31.xCoord, vec31.yCoord, vec31.zCoord, vec3.xCoord, vec3.yCoord + 0.05D, vec3.zCoord);
			}

			this.playSound("random.eat", 0.5F + 0.5F * (float)this.rand.nextInt(2), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2F + 1.0F);
		}
	}

	/**
	 * Used for when item use count runs out, ie: eating completed
	 */
	protected void onItemUseFinish()
	{
		if (this.itemInUse != null)
		{
			this.updateItemUse(this.itemInUse, 16);
			int i = this.itemInUse.stackSize;
			FakeEntityPlayer fake;
			ItemStack itemstack = this.itemInUse.onFoodEaten(this.worldObj, fake = getEntityPlayer());

			this.foodStats.setFoodLevel(fake.getFoodStats().getFoodLevel());
			this.foodStats.setFoodSaturationLevel(fake.getFoodStats().getSaturationLevel());

			if (itemstack != this.itemInUse || itemstack != null && itemstack.stackSize != i)
			{
				this.inventory.mainInventory[this.inventory.currentItem] = itemstack;

				if (itemstack.stackSize == 0)
				{
					this.inventory.mainInventory[this.inventory.currentItem] = null;
				}
			}

			this.clearItemInUse();
		}
	}

	protected void onNewPotionEffect(PotionEffect par1PotionEffect){
		super.onNewPotionEffect(par1PotionEffect);
		NetworkHandler.sendPacketToPlayers(watchingOwners, new Packet41EntityEffect(this.entityId, par1PotionEffect));
	}

	protected void onChangedPotionEffect(PotionEffect par1PotionEffect, boolean par2)
	{
		super.onChangedPotionEffect(par1PotionEffect, par2);
		NetworkHandler.sendPacketToPlayers(watchingOwners, new Packet41EntityEffect(this.entityId, par1PotionEffect));
	}

	protected void onFinishedPotionEffect(PotionEffect par1PotionEffect)
	{
		super.onFinishedPotionEffect(par1PotionEffect);
		NetworkHandler.sendPacketToPlayers(watchingOwners, new Packet42RemoveEntityEffect(this.entityId, par1PotionEffect));
	}

	public void onCollideItem(EntityItem item){
		if(item.delayBeforeCanPickup < 1){
			ItemStack stack = item.getEntityItem();
			if(stack != null){
				int added = inventory.addItemstackToInventory(stack);
				if(added > 0){
					playSound("random.pop", 0.2F, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7F + 1.0F) * 2.0F);
				}
				onItemPickup(item, added);
				if(stack.stackSize < 1){
					item.setDead();
				}
			}
		}
	}



	@Override
	public void onItemPickup(Entity entity, int par2) {
		super.onItemPickup(entity, par2);
		if(entity instanceof EntityItem){
			ItemStack stack = ((EntityItem)entity).getEntityItem();
			if(stack != null){
				onItemStackPickedUp(stack, par2);
			}
		}
	}

	public void onItemStackPickedUp(ItemStack stack, int i){
		if(stack.getItem() instanceof ItemArmor){
			ItemArmor armor = (ItemArmor)stack.getItem();
			EnumArmorMaterial mat = armor.getArmorMaterial();
			int armorType = armor.armorType;
			int armorSlot = 3-armorType;
			ItemStack previous = inventory.armorInventory[armorSlot];
			if(previous == null){
				ItemStack consumed = inventory.consumeInventoryItemStack(stack, 1);
				if(consumed != null){
					inventory.setArmorSlot(armorSlot, consumed);
				}
			}else{
				Item itemPrev = previous.getItem();
				if(itemPrev instanceof ItemArmor){
					ItemArmor prevArmor = (ItemArmor)itemPrev;
					float damageReduct1 = getArmourDamageReduction(stack, armor, armorType);//armor.getArmorMaterial().getDamageReductionAmount(armorType);
					float damageReduct2 = getArmourDamageReduction(previous, prevArmor, armorType);//prevArmor.getArmorMaterial().getDamageReductionAmount(armorType);
					double durability1 = (double)stack.getItemDamage() / (double)armor.getArmorMaterial().getDurability(armorType);
					double durability2 = (double)previous.getItemDamage() / (double)prevArmor.getArmorMaterial().getDurability(armorType);
					if(damageReduct1 > damageReduct2 
							|| (damageReduct1 == damageReduct2?durability1 < durability2:false)){
						ItemStack tempStack = previous.copy();
						inventory.addItemstackToInventory(tempStack);
						if(tempStack.stackSize < 1){
							ItemStack consumed = inventory.consumeInventoryItemStack(stack, 1);
							if(consumed != null){
								inventory.setArmorSlot(armorSlot, consumed);
							}
						}
					}
				}
			}
		}
	}

	public float getArmourDamageReduction(ItemStack stack, ItemArmor armour, int armourType){
		float reduction = armour.getArmorMaterial().getDamageReductionAmount(armourType);
		reduction += EnchantmentHelper.getEnchantmentLevel(Enchantment.protection.effectId, stack)*1.5;
		reduction += EnchantmentHelper.getEnchantmentLevel(Enchantment.featherFalling.effectId, stack);
		reduction += EnchantmentHelper.getEnchantmentLevel(Enchantment.blastProtection.effectId, stack);
		reduction += EnchantmentHelper.getEnchantmentLevel(Enchantment.fireProtection.effectId, stack);
		reduction += EnchantmentHelper.getEnchantmentLevel(Enchantment.projectileProtection.effectId, stack);
		return reduction;
	}



	public void commitSuicide() {
		this.setHealth(0);
		this.playSound(this.getDeathSound(), this.getSoundVolume(), this.getSoundPitch());
		this.onDeath(DamageSource.outOfWorld);
	}

	public void onDeath(DamageSource par1DamageSource) {
		super.onDeath(par1DamageSource);
//		System.out.println("On death");
		if (!worldObj.isRemote) {
			inventory.dropAllItems();
			dropAllXP();
		}
	}

	private void dropAllXP() {
		if(experienceTotal > 0){
			Random r = new Random();
			int xp = experienceTotal;
			if(xp > 85){
				xp = 85;
			}
			if(xp < 4){
				EntityXPOrb xpOrb = new EntityXPOrb(worldObj, posX, posY+.5, posZ, experienceTotal);
				xpOrb.motionX = (r.nextFloat()*2-1)/5;
				xpOrb.motionY = (r.nextFloat()*2-1)/5;
				xpOrb.motionZ = (r.nextFloat()*2-1)/5;
				xpOrb.moveEntity(xpOrb.motionX, xpOrb.motionY, xpOrb.motionZ);
				worldObj.spawnEntityInWorld(xpOrb);
			}else{
				int[] split = splitXP(xp);
				for(int a = 0; a < split.length; a++){
					EntityXPOrb xpOrb = new EntityXPOrb(worldObj, posX, posY+.5, posZ, split[a]);
					xpOrb.motionX = (r.nextFloat()*2-1)/5;
					xpOrb.motionY = (r.nextFloat()*2-1)/5;
					xpOrb.motionZ = (r.nextFloat()*2-1)/5;
					xpOrb.moveEntity(xpOrb.motionX, xpOrb.motionY, xpOrb.motionZ);
					worldObj.spawnEntityInWorld(xpOrb);
				}
			}
		}
	}

	public int[] splitXP(int xp){
		int[] ret = new int[4];
		int size = xp/4;
		for(int a = 0; a < ret.length; a++){
			ret[a] = size;
		}
		ret[3] = xp-(size*4) + size;
		return ret;
	}

	public void pickUpNearbyItems(){
		List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1D, 1.5D, 1D));
		if (list != null && !list.isEmpty()){
			for (int i = 0; i < list.size(); ++i){
				Entity entity = (Entity)list.get(i);
				if(entity instanceof EntityItem){
					onCollideItem((EntityItem)entity);
				}
			}
		}
	}

	public void updateExperience(){
		if(xpCooldown > 0){
			xpCooldown--;
		}
		List l = worldObj.getEntitiesWithinAABB(EntityXPOrb.class, boundingBox.expand(6, 2, 6));
		for(int a = 0; a < l.size(); a++){
			Object o = l.get(a);
			if(o instanceof EntityXPOrb){
				EntityXPOrb exp = (EntityXPOrb)o;
				if(isEntityAlive() && xpCooldown < 1 && getDistanceSqToEntityIncEye(exp) < 1 && !worldObj.isRemote){
					int value = exp.getXpValue();
					xpCooldown = 2;
					playSound("random.orb", 0.1F, 0.5F * ((rand.nextFloat() - rand.nextFloat()) * 0.7F + 1.8F));
					addExperience(value);
					exp.setDead();
					worldObj.removeEntity(exp);
				}else if(!dead){
					double var3 = (posX - exp.posX) / 8;
					double var5 = (posY + (double)getEyeHeight() - exp.posY) / 8;
					double var7 = (posZ - exp.posZ) / 8;
					double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
					double var11 = 1.0D - var9;
					if (var11 > 0.0D)
					{
						var11 *= var11;
						exp.motionX += var3 / var9 * var11 * 0.1D;
						exp.motionY += var5 / var9 * var11 * 0.1D;
						exp.motionZ += var7 / var9 * var11 * 0.1D;
					}
					exp.moveEntity(exp.motionX, exp.motionY, exp.motionZ);
				}
			}
		}
	}

	public double getDistanceSqToEntityIncEye(Entity par1Entity)
	{
		double d0 = this.posX - par1Entity.posX;
		double d1 = (this.posY+getEyeHeight()) - par1Entity.posY;
		double d2 = this.posZ - par1Entity.posZ;
		return d0 * d0 + d1 * d1 + d2 * d2;
	}
	/*	private void increaseLevel() {
		++this.experienceLevel;
	}*/
	public void addExperience(int par1) {
		int j = Integer.MAX_VALUE - this.experienceTotal;

		if (par1 > j)
		{
			par1 = j;
		}

		this.experience += (float)par1 / (float)this.xpBarCap();

		for (this.experienceTotal += par1; this.experience >= 1.0F; this.experience /= (float)this.xpBarCap())
		{
			this.experience = (this.experience - 1.0F) * (float)this.xpBarCap();
			this.addExperienceLevel(1);
		}
		onValueChanged(ID_EXPERIENCE, true);
	}

	public void addExperienceLevel(int par1)
	{
		this.experienceLevel += par1;

		if (this.experienceLevel < 0)
		{
			this.experienceLevel = 0;
			this.experience = 0.0F;
			this.experienceTotal = 0;
		}

		if (par1 > 0 && this.experienceLevel % 5 == 0 /*&& (float)this.field_82249_h < (float)this.ticksExisted - 100.0F*/)
		{
			float f = this.experienceLevel > 30 ? 1.0F : (float)this.experienceLevel / 30.0F;
			this.worldObj.playSoundAtEntity(this, "random.levelup", f * 0.75F, 1.0F);
			//            this.field_82249_h = this.ticksExisted;
		}
	}

	public int xpBarCap() {
		return this.experienceLevel >= 30 ? 62 + (this.experienceLevel - 30) * 7
				: (this.experienceLevel >= 15 ? 17 + (this.experienceLevel - 15) * 3
						: 17);
	}


	public boolean shouldHeal(){
		return this.getHealth() > 0.0F && this.getHealth() < getMaxHealth();
	}


	@Override
	protected boolean interact(EntityPlayer player) {
		if(isEntityAlive()){
			if(!worldObj.isRemote){
				if(owner == null || owner.equals("")){
					owner = player.username;
					player.addChatMessage("\2476You now own this clone!");
					this.onValueChanged(ID_OWNER, true);
				}
			}
			if(player instanceof EntityPlayerMP && canUseThisEntity(player.username)){
				player.openGui(CloneCraft.instance, GuiHandler.CLONEINVEN, worldObj, this.entityId, 0, 0);
			}
		}
		return true;
	}

	public boolean canUseThisEntity(String username){
		return (owner==null||owner.isEmpty()||!CloneCraft.config.areOwnersEnabled()?true:(owner.equals(username)));
	}

	public void setOwner(String ownerUsername){
		owner = ownerUsername;
	}

	public EntityPlayer getOwnerPlayer(){
		if(owner != null && owner.length() > 0){
			for(int a = 0; a < worldObj.playerEntities.size(); a++){
				if(owner.equals(((EntityPlayer)worldObj.playerEntities.get(a)).username)){
					return (EntityPlayer)worldObj.playerEntities.get(a);
				}
			}
		}
		return null;
	}

	public ResourceLocation defaultResource = new ResourceLocation("textures/entity/steve.png");

	public ResourceLocation currentResource = null;

	String name = "Steve";

	public String getTranslatedEntityName(){
		return name;
	}

	public String getFullEditedName(){
		return nameUnedited;
	}

	public String getName(){
		return name;
	}

	public void setName(String uneditedName){
		if(uneditedName == null || uneditedName.length() == 0){
			uneditedName = "Steve";
		}
		nameUnedited = uneditedName;
		if(!nameUnedited.startsWith("*")){
			if(worldObj.isRemote){
				updateSkin(nameUnedited);
			}
			name = nameUnedited;
		}else{
			String nameEdited = uneditedName.substring(1).replace("\\", "/");
			if(worldObj.isRemote){
				updateLocalSkin(nameEdited);
			}
			if(nameEdited.contains("/")){
				nameEdited = nameEdited.substring(nameEdited.lastIndexOf("/")+1);
			}
			if(nameEdited.contains(".")){
				nameEdited = nameEdited.substring(0, nameEdited.lastIndexOf("."));
			}
			if(nameEdited.length() > 0){
				nameEdited = nameEdited.substring(0,  1).toUpperCase() + nameEdited.substring(1);
			}
			this.name = nameEdited;
		}
		onValueChanged(ID_NAME, false);
	}


	@SideOnly(value = Side.CLIENT)
	public void updateLocalSkin(String editedName){
		//Checks to make sure the local skin actually exists. If it doesn't it sets the currentResource to the default (steve) resource

		currentResource = new ResourceLocation("textures/" + editedName);
		SimpleTexture tex = new SimpleTexture(currentResource);
		try{
			tex.loadTexture(Minecraft.getMinecraft().getResourceManager());
		}catch(Exception e){
			currentResource = defaultResource;
		}
	}

	@SideOnly(value = Side.CLIENT)
	public void updateSkin(String username){
		ResourceLocation resource = new ResourceLocation("skins/" + username);
		TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
		TextureObject object = texturemanager.getTexture(resource);
		if(object == null || !(object instanceof ThreadDownloadImageData)){
			object = new ThreadDownloadImageData("http://skins.minecraft.net/MinecraftSkins/" + username + ".png", defaultResource, new ImageBufferDownload());
			texturemanager.loadTexture(resource, object);
		}
		currentResource = resource;
	}



	//Rendering Stuff

	@SideOnly(value = Side.CLIENT)
	public ResourceLocation getSkinResource() {
		if(currentResource != null){
			return currentResource;
		}
		return defaultResource;
	}


	public Scoreboard getWorldScoreboard()
	{
		return this.worldObj.getScoreboard();
	}

	private ItemStack itemInUse;

	/**
	 * This field starts off equal to getMaxItemUseDuration and is decremented on each tick
	 */
	private int itemInUseCount;

	public void setItemInUse(ItemStack par1ItemStack, int par2)
	{
		if (par1ItemStack != this.itemInUse)
		{
			//			isItemInUse = true;
			this.itemInUse = par1ItemStack;
			this.itemInUseCount = par2;

			if (!this.worldObj.isRemote)
			{
				this.setEating(true);
			}
		}
	}

	@SideOnly(Side.CLIENT)

	/**
	 * returns the ItemStack containing the itemInUse
	 */
	public ItemStack getItemInUse()
	{
		return this.itemInUse;
	}

	@SideOnly(Side.CLIENT)

	/**
	 * Returns the item in use count
	 */
	public int getItemInUseCount()
	{
		return this.itemInUseCount;
	}

	/**
	 * Checks if the entity is currently using an item (e.g., bow, food, sword) by holding down the useItemButton
	 */
	public boolean isUsingItem()
	{
		return this.itemInUse != null;
	}

	@SideOnly(Side.CLIENT)

	/**
	 * gets the duration for how long the current itemInUse has been in use
	 */
	public int getItemInUseDuration()
	{
		return this.isUsingItem() ? this.itemInUse.getMaxItemUseDuration() - this.itemInUseCount : 0;
	}

	public void stopUsingItem()
	{
		if (this.itemInUse != null)
		{
			this.itemInUse.onPlayerStoppedUsing(this.worldObj, getEntityPlayer(), this.itemInUseCount);
		}

		this.clearItemInUse();
	}

	public void clearItemInUse()
	{
		this.itemInUse = null;
		this.itemInUseCount = 0;

		if (!this.worldObj.isRemote)
		{
			this.setEating(false);
		}
	}
/*

	public float getMaxHealth() {
		return 20;
	}*/
/*
	public double getHealth() {
		return getHealth();
	}*/

	@Override
	protected boolean canDespawn() {
		return false;
	}


	//TODO Inventory
	public InventoryClone inventory;



	public ItemStack getCurrentArmor(int par1)
	{
		return this.inventory.armorItemInSlot(par1);
	}

	@SideOnly(Side.CLIENT)

	/**
	 * Gets the Icon Index of the item currently held
	 */
	public Icon getItemIcon(ItemStack par1ItemStack, int par2)
	{
		Icon icon = super.getItemIcon(par1ItemStack, par2);

		if (par1ItemStack.itemID == Item.fishingRod.itemID/* && this.fishEntity != null*/)
		{
			icon = Item.fishingRod.func_94597_g();
		}
		else
		{
			if (par1ItemStack.getItem().requiresMultipleRenderPasses())
			{
				return par1ItemStack.getItem().getIcon(par1ItemStack, par2);
			}

			if (this.itemInUse != null && par1ItemStack.itemID == Item.bow.itemID)
			{
				int j = par1ItemStack.getMaxItemUseDuration() - this.itemInUseCount;

				//                System.out.println(j);

				if (j >= 18)
				{
					return Item.bow.getItemIconForUseDuration(2);
				}

				if (j > 13)
				{
					return Item.bow.getItemIconForUseDuration(1);
				}

				if (j > 0)
				{
					return Item.bow.getItemIconForUseDuration(0);
				}
			}
			icon = par1ItemStack.getItem().getIcon(par1ItemStack, par2, getEntityPlayer(), itemInUse, itemInUseCount);
		}

		return icon;
		//    	return getEntityPlayer().getItemIcon(par1ItemStack, par2);
	}

	@Override
	public ItemStack getHeldItem() {
		return getCurrentEquippedItem();
	}

	@Override
	public ItemStack getCurrentItemOrArmor(int i) {
		if(i == 0){
			return inventory.getCurrentItem();
		}else{
			return inventory.armorItemInSlot(i-1);
		}
	}

	@Override
	public void setCurrentItemOrArmor(int i, ItemStack itemstack) {
		if(i == 0){
			inventory.mainInventory[inventory.currentItem] = itemstack;
		}else{
			inventory.armorInventory[i-1] = itemstack;
		}
	}

	@Override
	public ItemStack[] getLastActiveItems() {
		return this.inventory.armorInventory;
	}

	FakeEntityPlayer fake = null;

	public FakeEntityPlayer getEntityPlayer() {
		if(fake != null){
			fake.update(this);
		}else{
			fake = new FakeEntityPlayer(this);
		}
		return fake;
	}

	public EntityItem dropPlayerItemWithRandomChoice(ItemStack par1ItemStack, boolean par2)
	{
		if (par1ItemStack == null)
		{
			return null;
		}
		else if (par1ItemStack.stackSize == 0)
		{
			return null;
		}
		else
		{
			EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - 0.30000001192092896D + (double)this.getEyeHeight(), this.posZ, par1ItemStack);
			entityitem.delayBeforeCanPickup = 40;
			float f = 0.1F;
			float f1;

			if (par2)
			{
				f1 = this.rand.nextFloat() * 0.5F;
				float f2 = this.rand.nextFloat() * (float)Math.PI * 2.0F;
				entityitem.motionX = (double)(-MathHelper.sin(f2) * f1);
				entityitem.motionZ = (double)(MathHelper.cos(f2) * f1);
				entityitem.motionY = 0.20000000298023224D;
			}
			else
			{
				f = 0.3F;
				entityitem.motionX = (double)(-MathHelper.sin(this.rotationYaw / 180.0F * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0F * (float)Math.PI) * f);
				entityitem.motionZ = (double)(MathHelper.cos(this.rotationYaw / 180.0F * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0F * (float)Math.PI) * f);
				entityitem.motionY = (double)(-MathHelper.sin(this.rotationPitch / 180.0F * (float)Math.PI) * f + 0.1F);
				f = 0.02F;
				f1 = this.rand.nextFloat() * (float)Math.PI * 2.0F;
				f *= this.rand.nextFloat();
				entityitem.motionX += Math.cos((double)f1) * (double)f;
				entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1F);
				entityitem.motionZ += Math.sin((double)f1) * (double)f;
			}

			this.joinEntityItemWithWorld(entityitem);
			return entityitem;
		}
	}

	/**
	 * Joins the passed in entity item with the world. Args: entityItem
	 */
	public void joinEntityItemWithWorld(EntityItem par1EntityItem){
		if (captureDrops)
		{
			capturedDrops.add(par1EntityItem);
			return;
		}
		this.worldObj.spawnEntityInWorld(par1EntityItem);
	}


	public boolean isAttacking() {
		return entityToAttack != null;
	}

	public FoodStatsClone getFoodStats() {
		return foodStats;
	}

	//TODO Guard Positions

	public int guardPosX, guardPosY, guardPosZ;

	public float guardYaw, guardPitch;

	public boolean saidError = false;

	//TODO Items

	public boolean hasItemForBlock(int id, int meta) {
		if(id >= 0 && id < Block.blocksList.length){
			Block b = Block.blocksList[id];
			if(b != null){
				if(b.blockMaterial.isToolNotRequired()){
					return true;
				}else{
					for(int a = 0; a < 9; a++){
						ItemStack stack = inventory.mainInventory[a];
						if(stack != null){
							if(/*theTool.getStrVsBlock(stack, b)*/getStrVsBlock(b, meta, stack) > 1.0f){
								return true;
							}
							/*Item item = stack.getItem();
							if(item instanceof ItemTool){
								ItemTool theTool = (ItemTool)item;

							}*/
						}
					}
					return false;
				}
			}
		}
		return true;
	}

	public float getStrVsBlock(Block par1Block, int meta, ItemStack stack)
	{
		float f = (stack == null ? 1.0F : stack.getItem().getStrVsBlock(stack, par1Block, meta));

		if (f > 1.0F)
		{
			int i = EnchantmentHelper.getEnchantmentLevel(Enchantment.efficiency.effectId, stack);//EnchantmentHelper.getEfficiencyModifier(this);
			ItemStack itemstack = this.inventory.getCurrentItem();

			if (i > 0 && itemstack != null)
			{
				float f1 = (float)(i * i + 1);

				boolean canHarvest = ForgeHooks.canToolHarvestBlock(par1Block, meta, itemstack);

				if (!canHarvest && f <= 1.0F)
				{
					f += f1 * 0.08F;
				}
				else
				{
					f += f1;
				}
			}
		}

		if (this.isPotionActive(Potion.digSpeed))
		{
			f *= 1.0F + (float)(this.getActivePotionEffect(Potion.digSpeed).getAmplifier() + 1) * 0.2F;
		}

		if (this.isPotionActive(Potion.digSlowdown))
		{
			f *= 1.0F - (float)(this.getActivePotionEffect(Potion.digSlowdown).getAmplifier() + 1) * 0.2F;
		}

		if (this.isInsideOfMaterial(Material.water) && !EnchantmentHelper.getAquaAffinityModifier(this))
		{
			f /= 5.0F;
		}

		if (!this.onGround)
		{
			f /= 5.0F;
		}
		return (f < 0 ? 0 : f);
	}



	//TODO May have to change this back to 'inventory.getCurrentItem()'
	public ItemStack getCurrentEquippedItem()
	{
		return this.selectedItem < 9 && this.selectedItem >= 0 ? inventory.mainInventory[this.selectedItem] : null;
	}

	public void destroyCurrentEquippedItem()
	{
		this.inventory.setInventorySlotContents(this.inventory.currentItem, (ItemStack)null);
	}

	public boolean selectToolForBlock(int id, int meta){
		if(id >= 0 && id < Block.blocksList.length){
			Block b = Block.blocksList[id];
			if(b != null){
				int index = -1;
				float strength = -1;


				float strTemp = 0;
				for(int a = 0; a < 9; a++){
					ItemStack stack = inventory.mainInventory[a];
					if(stack != null){
						if((strTemp = getStrVsBlock(b, meta, stack)) > strength){
							index = a;
							strength = strTemp;
						}
					}
				}

				if(index > -1){
					inventory.currentItem = index;
					return true;
				}else{
					return false;
				}
			}
		}
		return false;
	}

	//TODO Interaction

	EntityLivingBase entityToAttack;

	public boolean revenge = false;

	public int attackDelay = 8;

	int timeSinceLastAttack = 0;


	public EntityLivingBase getEntityToAttack(){
		return entityToAttack;
	}

	public void setTarget(EntityLivingBase par1Entity){
		this.entityToAttack = par1Entity;
		revenge = false;
	}

	public void attackEntity(EntityLivingBase par1Entity, float par2) {
		boolean shouldBowBeInUse = false;
		if(canEntityBeSeen(par1Entity)){
			if(par2 < 3.5){
				selectSword();
				if(timeSinceLastAttack == 0){
					attackTargetEntityWithCurrentItem(par1Entity);
					timeSinceLastAttack = attackDelay;
					addExhaustion(.3f);
				}
			}else if((par2 > 6 || getNavigator().noPath()) && par2 < 20 && /*getDistanceToEntityFromHead(par1Entity) < 20 && */hasBowAndArrow(true)){
				if(hasDirectLine(this, par1Entity)){
					shouldBowBeInUse = true;
					if(isChargingBow()){
						int timeUsed = itemInUse.getMaxItemUseDuration() - this.itemInUseCount;
						double requiredStrength = 20;//par2;
						if(timeUsed > 2 && timeUsed >= requiredStrength){
							tryShootArrow(timeUsed);
							clearItemInUse();
							shouldBowBeInUse = false;
						}
					}
				}
				/*if(hasDirectLine(this, par1Entity)){
					if(timeSinceLastArrow == 0){
						attackArrow(par1Entity);
						timeSinceLastArrow = arrowAttackDelay;
						addExhaustion(.3f);
					}else if(timeSinceLastArrow < 15){
						setBow = true;
						getNavigator().setSpeed(this.getMoveSpeed()/2);
					}
				}else{
					if(getNavigator().noPath()){
						setBow = true;
					}
				}*/
			}
		}
		setIsChargingBow(shouldBowBeInUse);
		if(shouldBowBeInUse){
			getNavigator().setSpeed(this.getMoveSpeed()/2);
		}
	}

	/*public void setWatching(boolean watch){
		if(watch){
			Minecraft.getMinecraft().renderViewEntity = this;
		}else{
			Minecraft.getMinecraft().renderViewEntity = Minecraft.getMinecraft().thePlayer;
		}
	}*/

	private boolean hasDirectLine(EntityClone fromE, EntityLivingBase toE) {
		Vec3 fromVec = Vec3.createVectorHelper(fromE.posX, fromE.posY+fromE.getEyeHeight(), fromE.posZ);
		Vec3 toVec = Vec3.createVectorHelper(toE.posX, toE.posY + toE.getEyeHeight(), toE.posZ);
		List list = worldObj.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox(
				fromE.posX < toE.posX?fromE.posX:toE.posX, 
						fromE.posY < toE.posY?fromE.posY:toE.posY, 
								fromE.posZ < toE.posZ?fromE.posZ:toE.posZ,  
										fromE.posX > toE.posX?fromE.posX:toE.posX, 
												fromE.posY > toE.posY?fromE.posY:toE.posY, 
														fromE.posZ > toE.posZ?fromE.posZ:toE.posZ).expand(2, 8, 2));
		list.remove(fromE);
		list.remove(toE);

		Ray ray = new Ray(fromVec, toVec);

		for(int a = 0; a < list.size(); a++){
			EntityLivingBase entityInTheWay;
			entityInTheWay = (EntityLivingBase)list.get(a);
			if(!options.shouldAttack(entityInTheWay)){
				AxisAlignedBB box = entityInTheWay.boundingBox.expand(0.5, 0.5, 0.5);
				if(ray.intersects(box)){
					return false;
				}
			}
		}
		return true;
	}

	public void setIsChargingBow(boolean val){
		//		System.out.println(val);
		boolean currentlyCharging = isChargingBow();

		if(val && !currentlyCharging){
			//			System.out.println("A");
			this.setItemInUse(inventory.getCurrentItem(), Item.bow.getMaxItemUseDuration(inventory.getCurrentItem()));
		}else if(!val && isChargingBow()){
			//			System.out.println("B");
			//			tryShootArrow();
			this.clearItemInUse();//(inventory.getCurrentItem(), Item.bow.getMaxItemUseDuration(inventory.getCurrentItem()));

		}
	}

	public void tryShootArrow(int timeUsed){
		EntityLivingBase e = getEntityToAttack();
		if(e != null && e.isEntityAlive()){
			attackArrow(e, timeUsed);
		}

		/*		ItemStack par1ItemStack = this.itemInUse;
		if(par1ItemStack != null){

			int j = Item.bow.getMaxItemUseDuration(par1ItemStack) - itemInUseCount;

			ArrowLooseEvent event = new ArrowLooseEvent(getEntityPlayer(), par1ItemStack, j);
			MinecraftForge.EVENT_BUS.post(event);
			if (event.isCanceled())
			{
				return;
			}
			j = event.charge;

			boolean flag = EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, par1ItemStack) > 0;

			if (flag || inventory.hasItem(Item.arrow.itemID))
			{
				float f = (float)j / 20.0F;
				f = (f * f + f * 2.0F) / 3.0F;

				if ((double)f < 0.1D)
				{
					return;
				}

				if (f > 1.0F)
				{
					f = 1.0F;
				}

				EntityArrow entityarrow = new EntityArrow(worldObj, this, f * 2.0F);

				if (f == 1.0F)
				{
					entityarrow.setIsCritical(true);
				}

				int k = EnchantmentHelper.getEnchantmentLevel(Enchantment.power.effectId, par1ItemStack);

				if (k > 0)
				{
					entityarrow.setDamage(entityarrow.getDamage() + (double)k * 0.5D + 0.5D);
				}

				int l = EnchantmentHelper.getEnchantmentLevel(Enchantment.punch.effectId, par1ItemStack);

				if (l > 0)
				{
					entityarrow.setKnockbackStrength(l);
				}

				if (EnchantmentHelper.getEnchantmentLevel(Enchantment.flame.effectId, par1ItemStack) > 0)
				{
					entityarrow.setFire(100);
				}

				par1ItemStack.damageItem(1, this);
				worldObj.playSoundAtEntity(this, "random.bow", 1.0F, 1.0F / (rand.nextFloat() * 0.4F + 1.2F) + f * 0.5F);

				if (flag)
				{
					entityarrow.canBePickedUp = 2;
				}
				else
				{
					inventory.consumeInventoryItem(Item.arrow.itemID);
				}

				if (!worldObj.isRemote)
				{
					worldObj.spawnEntityInWorld(entityarrow);
				}
			}
		}*/
	}

	public boolean isChargingBow(){
		return this.isUsingItem() && this.getItemInUse().itemID == Item.bow.itemID;
	}

	/**
	 * Returns the distance to the entity. Args: entity
	 */
	public float getDistanceToEntityFromHead(Entity par1Entity)
	{
		float f = (float)(this.posX - par1Entity.posX);
		float f1 = (float)((this.posY + getEyeHeight()) - par1Entity.posY);
		float f2 = (float)(this.posZ - par1Entity.posZ);
		return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
	}



	public void attackTargetEntityWithCurrentItem(Entity par1Entity){
		ItemStack stack = getCurrentEquippedItem();
		if (stack != null && stack.getItem().onLeftClickEntity(stack, this.getEntityPlayer(), par1Entity))
		{
			return;
		}
		if (par1Entity.canAttackWithItem())
		{
			if (!par1Entity.hitByEntity(this))
			{
				float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
				int i = 0;
				float f1 = 0.0F;

				if (par1Entity instanceof EntityLivingBase)
				{
					f1 = EnchantmentHelper.getEnchantmentModifierLiving(this, (EntityLivingBase)par1Entity);
					i += EnchantmentHelper.getKnockbackModifier(this, (EntityLivingBase)par1Entity);
				}

				if (this.isSprinting())
				{
					++i;
				}

				if (f > 0.0F || f1 > 0.0F)
				{
					boolean flag = this.fallDistance > 0.0F && !this.onGround && !this.isOnLadder() && !this.isInWater() && !this.isPotionActive(Potion.blindness) && this.ridingEntity == null && par1Entity instanceof EntityLivingBase;

					if (flag && f > 0.0F)
					{
						f *= 1.5F;
					}

					f += f1;
					boolean flag1 = false;
					int j = EnchantmentHelper.getFireAspectModifier(this);

					if (par1Entity instanceof EntityLivingBase && j > 0 && !par1Entity.isBurning())
					{
						flag1 = true;
						par1Entity.setFire(1);
					}

					boolean flag2 = par1Entity.attackEntityFrom(DamageSource.causePlayerDamage(this.getEntityPlayer()), f);
					swingItem();
					if (flag2)
					{
						if (i > 0)
						{
							par1Entity.addVelocity((double)(-MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0F) * (float)i * 0.5F), 0.1D, (double)(MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0F) * (float)i * 0.5F));
							this.motionX *= 0.6D;
							this.motionZ *= 0.6D;
							this.setSprinting(false);
						}

						/* if (flag)
                        {
                            this.onCriticalHit(par1Entity);
                        }

                        if (f1 > 0.0F)
                        {
                            this.onEnchantmentCritical(par1Entity);
                        }

                        if (f >= 18.0F)
                        {
                            this.triggerAchievement(AchievementList.overkill);
                        }*/

						this.setLastAttacker(par1Entity);

						if (par1Entity instanceof EntityLivingBase)
						{
							EnchantmentThorns.func_92096_a(this, (EntityLivingBase)par1Entity, this.rand);
						}
					}

					ItemStack itemstack = this.getCurrentEquippedItem();
					Object object = par1Entity;

					if (par1Entity instanceof EntityDragonPart)
					{
						IEntityMultiPart ientitymultipart = ((EntityDragonPart)par1Entity).entityDragonObj;

						if (ientitymultipart != null && ientitymultipart instanceof EntityLivingBase)
						{
							object = (EntityLivingBase)ientitymultipart;
						}
					}

					if (itemstack != null && object instanceof EntityLivingBase)
					{
						itemstack.hitEntity((EntityLivingBase)object, this.getEntityPlayer());

						if (itemstack.stackSize <= 0)
						{
							this.destroyCurrentEquippedItem();
						}
					}

					if (par1Entity instanceof EntityLivingBase)
					{
						if (j > 0 && flag2)
						{
							par1Entity.setFire(j * 4);
						}
						else if (flag1)
						{
							par1Entity.extinguish();
						}
					}

					this.addExhaustion(0.3F);
				}
			}
		}
	}

	public void addExhaustion(float par1){
		if (!this.worldObj.isRemote)
		{
			this.foodStats.addExhaustion(par1);
		}
	}

	private boolean selectSword() {
		int bestSwordIndex = -1;
		float bestSwordDamage = -1;
		for(int a = 0; a < 9; a++){
			ItemStack item = inventory.mainInventory[a];
			if(item != null && ItemSword.class.isAssignableFrom(item.getItem().getClass())){
				ItemSword sword = (ItemSword)item.getItem();
				EnumToolMaterial mat = Reflect.get(sword, Reflect.toolMaterial, EnumToolMaterial.class);//.toolMaterial(sword);
				if(mat != null){
					float goodness = mat.getEfficiencyOnProperMaterial();
					if(goodness > bestSwordDamage || bestSwordIndex < 0){
						bestSwordIndex = a;
						bestSwordDamage = goodness;
					}
				}
			}
		}
		if(bestSwordIndex > -1){
			inventory.currentItem = bestSwordIndex;
		}
		return false;
	}



	public boolean hasBowAndArrow(boolean set){
		if(inventory.hasItem(Item.arrow.itemID)){
			int goodness = -1;
			int slot = -1;
			for(int a = 0; a < 9; a++){
				ItemStack stack = inventory.mainInventory[a];
				if(stack != null && stack.itemID == Item.bow.itemID){
					if(!set){
						return true;
					}
					int power = EnchantmentHelper.getEnchantmentLevel(Enchantment.power.effectId, stack);
					int flame = EnchantmentHelper.getEnchantmentLevel(Enchantment.flame.effectId, stack)>0?2:0;
					int infinity = EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, stack)>0?3:0;
					int goodness2 = power + flame + infinity;
					if(goodness2 > goodness){
						slot = a;
						goodness = goodness2;
					}
				}
			}
			if(set && slot > -1){
				inventory.currentItem = slot;
				return true;
			}
		}
		return false;
	}

	private void attackArrow(EntityLivingBase par1Entity, int timeUsed) {
		ItemStack held = this.getHeldItem();
		float f = (float)timeUsed / 20.0F;
		f = (f * f + f * 2.0F) / 3.0F;

		//0.1 = (x * x + x * 2) / 3

		if ((double)f < 0.1D)
		{
			return;
		}

		if (f > 1.0F)
		{
			f = 1.0F;
		}
		EntityArrow var2 = new EntityArrow(this.worldObj, this, par1Entity, 1.6F, f*2);
		var2.canBePickedUp = 1;
		int var3 = EnchantmentHelper.getEnchantmentLevel(Enchantment.power.effectId, held);
		int var4 = EnchantmentHelper.getEnchantmentLevel(Enchantment.punch.effectId, held);

		if (var3 > 0)
		{
			var2.setDamage(var2.getDamage() + (double)var3 * 0.5D + 0.5D);
		}

		if (var4 > 0)
		{
			var2.setKnockbackStrength(var4);
		}

		if (EnchantmentHelper.getEnchantmentLevel(Enchantment.flame.effectId, this.getHeldItem()) > 0)
		{
			var2.setFire(100);
		}
		if(held != null){held.damageItem(1, getEntityPlayer());}
		this.playSound("random.bow", 1.0F, 1.0F / (this.getRNG().nextFloat() * 0.4F + 0.8F));
		this.worldObj.spawnEntityInWorld(var2);
		int var5 = EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, this.getHeldItem());
		if(var5 < 1){
			inventory.consumeInventoryItem(Item.arrow.itemID);
			var2.canBePickedUp = 0;
		}
	}

	//Mining

	public boolean notMining() {
		return !aiBreakBlocks.isMining;
	}

	public boolean isInsideSeeThrough(MovingObjectPosition mop, Entity e){
		if(mop == null || e == null){
			return false;
		}
		if(e.posX >= mop.blockX && e.posX-1 < mop.blockX){
			if(e.posY >= mop.blockY && e.posY-1 < mop.blockY){
				if(e.posZ >= mop.blockZ && e.posZ-1 < mop.blockZ){
					return isSeeThroughBlock(mop.blockX, mop.blockY, mop.blockZ);
				}
			}
		}
		return false;

	}

	public boolean isSeeThroughBlock(Block block){
		if(block == null){
			return false;
		}
		Material mat = block.blockMaterial;
		if(mat != null){
			if(!mat.isOpaque() || mat.isLiquid() || mat.equals(Material.air) || mat.equals(Material.glass) || mat.equals(Material.leaves) || mat.equals(Material.glass) || mat.equals(Material.ice) || mat.equals(Material.portal) || mat.equals(Material.plants)){
				return true;
			}
		}
		return false;
	}

	public boolean isSeeThroughBlock(int x, int y, int z){
		int id = worldObj.getBlockId(x, y, z);
		if(id > 0){

			try{
				Block block = Block.blocksList[id];
				if(block != null){
					return block.getCollisionBoundingBoxFromPool(worldObj, x, y, z) == null || isSeeThroughBlock(block);
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return false;
	}

	public boolean canHarvestBlock(Block par1Block)
	{
		return this.inventory.canHarvestBlock(par1Block);
	}

	public float getCurrentPlayerStrVsBlock(Block par1Block)
	{
		float var2 = this.inventory.getStrVsBlock(par1Block);
		int var3 = EnchantmentHelper.getEfficiencyModifier(this);
		ItemStack var4 = this.inventory.getCurrentItem();

		if (var3 > 0 && var4 != null)
		{
			float var5 = (float)(var3 * var3 + 1);

			if (!var4.canHarvestBlock(par1Block) && var2 <= 1.0F)
			{
				var2 += var5 * 0.08F;
			}
			else
			{
				var2 += var5;
			}
		}

		if (this.isPotionActive(Potion.digSpeed))
		{
			var2 *= 1.0F + (float)(this.getActivePotionEffect(Potion.digSpeed).getAmplifier() + 1) * 0.2F;
		}

		if (this.isPotionActive(Potion.digSlowdown))
		{
			var2 *= 1.0F - (float)(this.getActivePotionEffect(Potion.digSlowdown).getAmplifier() + 1) * 0.2F;
		}

		if (this.isInsideOfMaterial(Material.water) && !EnchantmentHelper.getAquaAffinityModifier(this))
		{
			var2 /= 5.0F;
		}

		if (!this.onGround)
		{
			var2 /= 5.0F;
		}

		return var2;
	}

	public double getDistanceSqFromEye(double par1, double par3, double par5)
	{
		double var7 = this.posX - par1;
		double var9 = (this.posY+.5) - par3;
		double var11 = this.posZ - par5;
		return var7 * var7 + var9 * var9 + var11 * var11;
	}



	//Network
	EntityPlayer[] currentWatchingPlayers = new EntityPlayer[0];

	EntityPlayer[] lastWatchingPlayers = new EntityPlayer[0];

	EntityPlayer[] watchingOwners = new EntityPlayer[0];

	public void updateMyDataToNewWatchers(){
		if(ticksExisted % 5 == 0){
			EntityTrackerEntry tracker = CloneCraftUtils.getTracker(this);
			if(tracker != null){
				ArrayList<EntityPlayer> trackingOwners = new ArrayList<EntityPlayer>();
				lastWatchingPlayers = currentWatchingPlayers.clone();
				currentWatchingPlayers = (EntityPlayer[])tracker.trackingPlayers.toArray(new EntityPlayer[tracker.trackingPlayers.size()]);
				for(int a = 0; a < currentWatchingPlayers.length; a++){
					if(canUseThisEntity(currentWatchingPlayers[a].username)){
						trackingOwners.add(currentWatchingPlayers[a]);
					}

					if(!ArrayUtils.contains(lastWatchingPlayers, currentWatchingPlayers[a])){
						if(canUseThisEntity(currentWatchingPlayers[a].username)){
							updateAllData(currentWatchingPlayers[a]);
						}else{
							updatePublicData(currentWatchingPlayers[a]);
						}
					}
				}
				watchingOwners = trackingOwners.toArray(new EntityPlayer[trackingOwners.size()]);
			}
		}
	}

	public EntityPlayer[] getWatchingOwners(){
		return watchingOwners;
	}

	private Packet previousPacketSyncDataAll;
	SyncData[] previousSyncDataAll = null;

	private void updateAllData(EntityPlayer... entityPlayer) {
		SyncData[] data = sync.getSyncDataForAllValues();
		if(data != null){
			Packet send = null;
			if(previousSyncDataAll == data){
				send = previousPacketSyncDataAll;
			}else{
				send = new Handler15Synchronize(this, data).createPacket(Side.CLIENT);
				previousPacketSyncDataAll = send;
			}
			NetworkHandler.sendPacketToPlayers(entityPlayer, send);
		}
		previousSyncDataAll = data;

		updatePublicNBTData(entityPlayer);
	}

	@Override
	public DataSynchronizer getSyncer() {
		return sync;
	}


	private void updatePublicNBTData(EntityPlayer... entityPlayer){
		Handler6UpdateAll handler = new Handler6UpdateAll(this);
		handler.sendToClients(entityPlayer);
	}


	private Packet previousPacketSyncDataPublic;
	SyncData[] previousSyncDataPublic = null;

	private void updatePublicData(EntityPlayer... entityPlayer) {
		SyncData[] data = sync.getSyncDataForAllValues();
		if(data != null){
			Packet send = null;
			if(previousSyncDataPublic == data){
				send = previousPacketSyncDataPublic;
			}else{
				send = new Handler15Synchronize(this, data[0]).createPacket(Side.CLIENT);
				previousPacketSyncDataPublic = send;
			}
			NetworkHandler.sendPacketToPlayers(entityPlayer, send);
		}
		previousSyncDataPublic = data;

		updatePublicNBTData(entityPlayer);
	}


	

	@Override
	public void sendData(SyncData[] data) {
		Handler15Synchronize handlerToOwner = new Handler15Synchronize(this, data);
		Handler15Synchronize handlerToGeneral = new Handler15Synchronize(this, data[0]);

		handlerToOwner.sendToClients(watchingOwners);
		handlerToGeneral.sendToClients(currentWatchingPlayers);
	}

	@Override
	public boolean canSet(int id, Object value, Object setter) {
		if(!worldObj.isRemote){
			EntityPlayer player = (EntityPlayer)setter;
			if(id == ID_NAME && this.canUseThisEntity(player.username)){
				return true;
			}

			return false;
		}
		return true;
	}

	@Override
	public void anteSet(int id, Object value) {
	}

	@Override
	public void postSet(int id, Object value) {
		if(id == ID_NAME){
			setName((String)value);
		}
	}

	public void onValueChanged(int subId, boolean allOrOwners) {
		sync.checkValue(subId);
	}

	public void sendValueToServer(int... ids){
		SyncData[] datas = sync.getForcedSyncDataForIds(ids);
		Handler15Synchronize handler = new Handler15Synchronize(this, datas);
		handler.sendToServer();
	}

	public void sendValueToClient(EntityPlayer toSendTo, int... ids){
		SyncData[] datas = sync.getForcedSyncDataForIds(ids);
		if(datas != null && datas.length > 0){
			Handler15Synchronize handler = new Handler15Synchronize(this, datas);
			if(toSendTo != null){
				handler.sendToClient(toSendTo);
			}else{
				handler.sendToAllWatching(this);
			}
		}	
	}


	//Saving / Loading

	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		writeAllCloneData(nbt);
	}

	public void writeAllCloneData(NBTTagCompound nbt){
		writePrivateData(nbt);
		writePublicData(nbt);
	}

	public void writePrivateData(NBTTagCompound nbt){
		options.save(nbt);
		nbt.setTag("Inventory", inventory.writeToNBT(new NBTTagList()));
		foodStats.writeNBT(nbt);
		nbt.setFloat("experience", experience);
		nbt.setInteger("experienceLevel", experienceLevel);
		nbt.setInteger("experienceTotal", experienceTotal);
	}

	public void writePublicData(NBTTagCompound nbt){
		nbt.setInteger("teamID", team.teamID);
		nbt.setString("name", nameUnedited);
		nbt.setString("owner", owner==null?"":owner);
		nbt.setFloat("scale", scale);
		options.savePublicData(nbt);
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		readAllCloneData(nbt);
	}

	public void readAllCloneData(NBTTagCompound nbt){
		readPrivateData(nbt);
		readPublicData(nbt);
	}

	public void readPrivateData(NBTTagCompound nbt){
		options.load(nbt);
		NBTTagList nbttaglist = nbt.getTagList("Inventory");
		inventory.readFromNBT(nbttaglist);
		foodStats.readNBT(nbt);
		experience = nbt.getFloat("experience");
		experienceLevel = nbt.getInteger("experienceLevel");
		experienceTotal = nbt.getInteger("experienceTotal");
	}

	public void readPublicData(NBTTagCompound nbt){
		team = PlayerTeam.getByID(nbt.getInteger("teamID"));
		setName(nbt.getString("name"));
		owner = nbt.getString("owner");
		scale = nbt.getFloat("scale");
		options.loadPublicData(nbt);
	}
	@SideOnly(value = Side.CLIENT)
	public void spawnExplosionParticles(){
		spawnExplosionParticles(posX, posY, posZ, height, worldObj);
	}

	@SideOnly(value = Side.CLIENT)
	public void spawnExplosionParticles(final double posX, final double posY, final double posZ, final double height, final World theWorld){
		theWorld.playSound(posX, posY, posZ, "random.explode", .5F, (1.0F + (theWorld.rand.nextFloat() - theWorld.rand.nextFloat()) * 0.1F) * 0.2F, false);
		Random r = new Random();
		for(int a = 0; a < 200; a++){
			double done = a/200.0;
			double yOffset = done*height*2 - height/2 ;
			double x = Math.sin(done * Math.PI * 10);
			double z = Math.cos(done * Math.PI * 10);
			theWorld.spawnParticle("reddust", posX + x, posY + yOffset, posZ + z, r.nextFloat()*.4+.2, r.nextFloat()*.1, r.nextFloat()*.1);
		}


		for(int a = 0; a < 200; a++){
			double done = ((double)a) / 200;

			double rads = (Math.PI*2) * done;

			double x = Math.sin(rads);
			double z = Math.cos(rads);
			CloneCraftWorld.spawnParticleInRange(new EntityExplodeCollapseFX(theWorld, posX, posY + height/2, posZ, x*25, r.nextFloat()*2 - 1, z*25), 40);
		}

		new Thread(){
			public boolean isGamePaused(){
				return Reflect.get(Minecraft.getMinecraft(), Reflect.isGamePaused, Boolean.class);
			}
			
			List smokeFXLayer;
			
			public boolean canSpawnParticle(int amount){
				if(smokeFXLayer != null){
					return smokeFXLayer.size() + amount <= 3750;
				}
				return false;
			}

			public void run(){
				Minecraft mc = Minecraft.getMinecraft();
				List[] fxLayers = Reflect.get(mc.effectRenderer, Reflect.fxLayers, List[].class);
				if(fxLayers != null && fxLayers.length > 0){
					smokeFXLayer = fxLayers[0];
				}
				long startTime = System.currentTimeMillis();
				for(int a = 0; a < 1000; a++){
					if(mc.theWorld == null){
						break;
					}
					double done = ((double)a) / 1000;

					double yoffset = Math.sin(done*Math.PI) * height * 10;

					double rads = (Math.PI*12) * done*4;

					double x = Math.sin(rads)/16.0;
					double z = Math.cos(rads)/16.0;
					if(canSpawnParticle(2)){
						CloneCraftWorld.spawnParticleIgnoreDistance(new EntitySmokeFX(theWorld, posX, posY + (height/2) +yoffset, posZ, x, 0, z));
						CloneCraftWorld.spawnParticleIgnoreDistance(new EntitySmokeFX(theWorld, posX, posY + (height/2) -yoffset, posZ, x, 0, z));
					}
					if(isGamePaused()){
						int maximum = 3600000;
						long sleepStartTime = System.currentTimeMillis();
						while(isGamePaused() && maximum-- > 0 && mc.theWorld != null){
							try{
								Thread.sleep(1);
							}catch(Exception e){
								e.printStackTrace();
							}
						}
						long sleepEndTime = System.currentTimeMillis();
						startTime += sleepEndTime - sleepStartTime;
					}else{
						long timeToGoTo = (a+1)*5 + startTime;
						long currentTime = System.currentTimeMillis();
						long timeToSleep = timeToGoTo - currentTime;
						if(timeToSleep > 0){
							try{
								Thread.sleep(timeToSleep);
							}catch(Exception e){
								e.printStackTrace();
							}
						}else if(timeToSleep > 5){
							int toSkip = (int)(timeToSleep / 5) - 1;
							a += toSkip;
						}
					}

				}


			}
		}.start();
	}

	private static double gd(Random r){
		return (r.nextDouble()*1.5d)-.75d;
	}

	public double getReach() {
		return 4.5;
	}

	public void setCurrentItem(int stackSlot) {
		this.selectedItem = stackSlot;
		this.inventory.currentItem = stackSlot;
		this.onValueChanged(ID_SELECTED_ITEM, false);
	}

	protected int getExperiencePoints(EntityPlayer par1EntityPlayer)
	{
		return super.getExperiencePoints(par1EntityPlayer);
	}

	protected void jump()
	{
		super.jump();
	}

	protected void damageArmor(float par1)
	{
		this.inventory.damageArmor(par1);
	}

	public float getCurrentPlayerStrVsBlock(Block par1Block, boolean par2, int meta)
	{
		ItemStack stack = inventory.getCurrentItem();
		float f = (stack == null ? 1.0F : stack.getItem().getStrVsBlock(stack, par1Block, meta));

		if (f > 1.0F)
		{
			int i = EnchantmentHelper.getEfficiencyModifier(this);
			ItemStack itemstack = this.inventory.getCurrentItem();

			if (i > 0 && itemstack != null)
			{
				float f1 = (float)(i * i + 1);

				boolean canHarvest = ForgeHooks.canToolHarvestBlock(par1Block, meta, itemstack);

				if (!canHarvest && f <= 1.0F)
				{
					f += f1 * 0.08F;
				}
				else
				{
					f += f1;
				}
			}
		}

		if (this.isPotionActive(Potion.digSpeed))
		{
			f *= 1.0F + (float)(this.getActivePotionEffect(Potion.digSpeed).getAmplifier() + 1) * 0.2F;
		}

		if (this.isPotionActive(Potion.digSlowdown))
		{
			f *= 1.0F - (float)(this.getActivePotionEffect(Potion.digSlowdown).getAmplifier() + 1) * 0.2F;
		}

		if (this.isInsideOfMaterial(Material.water) && !EnchantmentHelper.getAquaAffinityModifier(this))
		{
			f /= 5.0F;
		}

		if (!this.onGround)
		{
			f /= 5.0F;
		}

		f = ForgeEventFactory.getBreakSpeed(getEntityPlayer(), par1Block, meta, f);
		return (f < 0 ? 0 : f);
	}

	/**
	 * Returns how strong the player is against the specified block at this moment
	 * Deprecated in favor of the more sensitive version
	 */
	@Deprecated
	public float getCurrentPlayerStrVsBlock(Block par1Block, boolean par2)
	{
		return getCurrentPlayerStrVsBlock(par1Block, par2, 0);
	}

}
